<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Vessel extends Model 
{

    protected $table = 'vessels';
    public $timestamps = true;
    protected $fillable = array('name', 'desc', 'vessel_number', 'width', 'vessel_model', 'length', 'speed', 'image', 'grouping', 'max_passengers', 'default_route');

    public function createdBy()
    {
        return $this->belongsTo('User', 'created_by');
    }

    public function vesselModel()
    {
        return $this->belongsTo('VesselModel', 'vessel_model');
    }

    public function lines()
    {
        return $this->hasMany('Lien', 'vessel_id');
    }

    public function vesselCabinsCounts()
    {
        return $this->hasMany('VesselCabinsCount', 'vessel_id');
    }

}